import pickle 
import numpy as np  
import pandas as pd
from pil import image
from skimage.metrics import structural_similarity
import imageio

import pandas as pd
import numpy as np

def compare_dataframes(df_origin, df_1, df_2):
    # 首先检查行的顺序
    if not (df_1.index.equals(df_2.index)):
        return false

    # 检查df_1是否只包含df_origin中的列
    if all(col in df_origin.columns for col in df_1.columns):
        # 第一类：df_1不包含df_origin中不存在的新列
        # 检查列名和数据是否一致（考虑不同顺序的列名）
        if set(df_1.columns) != set(df_2.columns):
            return false
        for col in df_1.columns:
            df_2_col = df_2[col] if col in df_2.columns else df_2[df_1.columns[df_1.columns == col][0]]
            if df_1[col].dtype.kind in 'ifc' and df_2_col.dtype.kind in 'ifc':
                if not np.allclose(df_1[col], df_2_col, equal_nan=true):
                    return false
            elif not df_1[col].equals(df_2_col):
                return false
    else:
        # 第二类：df_1包含df_origin中不存在的新列
        for col in df_1.columns:
            if col not in df_origin.columns:
                # 对于新生成的列，找到df_2中数据相同的列
                found_match = false
                for df_2_col in df_2.columns:
                    if df_1[col].dtype.kind in 'ifc' and df_2[df_2_col].dtype.kind in 'ifc':
                        # 数值列使用np.allclose比较
                        if np.allclose(df_1[col], df_2[df_2_col], equal_nan=true):
                            found_match = true
                            break
                    elif df_1[col].dtype == df_2[df_2_col].dtype:
                        # 非数值列直接比较
                        if df_1[col].equals(df_2[df_2_col]):
                            found_match = true
                            break
                if not found_match:
                    return false

    return true


# replace <ai_res> and <ref_res> with the actual ai and reference outputs 
try:
    with open("pred_result/performance_data.pkl", "rb") as fp:
        machine_result = pickle.load(fp)
except:
        machine_result = none

with open("ref_result/performance_data.pkl", "rb") as fr:
    reference_result = pickle.load(fr)

credit_customers = pd.read_csv("YOUR_DIR/tapilot_data/all_data_v2/atp_tennis.csv") 
# call the satisfies_user_requirements function with both outputs  
try:
    result = compare_dataframes(credit_customers, machine_result, reference_result)
except:
    result = false 

print(result)
